
// SimParm: Simple and flexible C++ configuration framework
// Copyright (C) 2007 Australian National University
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// Contact:
// Kevin Pulo
// kevin.pulo@anu.edu.au
// Leonard Huxley Bldg 56
// Australian National University, ACT, 0200, Australia

#if !defined(CONFIGSET_HH)
#define CONFIGSET_HH

#include <iostream>
#include <string>
#include <vector>
#include <map>
#include "ConfigEntry.hh"

using namespace std;

class ConfigSet {
	public:
		map<string,ConfigEntry*> lookup;
		vector<ConfigEntry*> ordered;
		istream *in;
		int infd;
		ostream *out;
		int outfd;
		//bool attached;
		ConfigEntryBool attached;
		vector<changecallback_t> changecallbacks;

		ConfigSet();
		ConfigSet(istream *in, int infd, ostream *out, int outfd);

		void setIO(istream *in, int infd, ostream *out, int outfd);
		void pulse();
		bool inputWaiting();  // should be private, who cares
		void serviceInput();

		void register_entry(ConfigEntry *entry);
		void register_unowned_entry(ConfigEntry *entry);
		void output_definition(ostream &out);
		void addChangeCallback(changecallback_t callback);
		void removeChangeCallback(changecallback_t callback);

		ConfigEntry *operator[](string name);

		istream& inputSingleEntry(istream& in);
		istream& inputAllEntries(istream& in);
		bool readConfig(int argc, char *argv[]);
		friend istream& operator>>(istream& in, ConfigSet &configSet);
		friend ostream& operator<<(ostream& out, const ConfigSet &configSet);
};

#endif

