/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;

class ConfigEntryLong
extends ConfigEntryNumber {
    private long value = 0L;
    private long increment = 0L;
    private boolean hasmin;
    private long minvalue;
    private boolean hasmax;
    private long maxvalue;
    private boolean unsigned;

    public ConfigEntryLong() {
        this.setNoMin();
        this.setNoMax();
    }

    public ConfigEntryLong(boolean bl) {
        this();
        this.unsigned = bl;
    }

    public boolean setValue(String string, boolean bl, boolean bl2) {
        try {
            this.setValue(Long.parseLong(string), bl, bl2);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public void setValue(long l, boolean bl, boolean bl2) {
        if (this.hasmin && l < this.minvalue) {
            l = this.minvalue;
        }
        if (this.hasmax && l > this.maxvalue) {
            l = this.maxvalue;
        }
        if (this.unsigned && l < 0L) {
            l = 0L;
        }
        if (this.value != l) {
            this.value = l;
            if (bl) {
                this.doPrint();
            }
        }
        if (bl2) {
            this.textField.setText(Long.toString(this.value));
        }
    }

    public boolean setValueFromInputStream(String string) {
        return this.setValue(string, false, true);
    }

    public void adjustValue(int n) {
        this.setValue(this.value - (long)n * this.increment, true, true);
    }

    public void setMin(long l) {
        this.hasmin = true;
        if (this.unsigned && l < 0L) {
            l = 0L;
        }
        this.minvalue = l;
    }

    public void setNoMin() {
        this.hasmin = false;
    }

    public void setMax(long l) {
        this.hasmax = true;
        if (this.unsigned && l < 0L) {
            l = 0L;
        }
        this.maxvalue = l;
    }

    public void setNoMax() {
        this.hasmax = false;
    }

    public void setIncrement(long l) {
        this.increment = l;
    }

    public void doSpecificPrint(PrintStream printStream) {
        printStream.print(this.value);
    }

    public void readDefinitionSpecific(BufferedReader bufferedReader) throws IOException {
        this.setValue(ConfigEntryLong.readLong(bufferedReader, "value"), false, true);
        this.setIncrement(ConfigEntryLong.readLong(bufferedReader, "increment"));
        this.hasmin = ConfigEntryLong.readBoolean(bufferedReader, "hasmin");
        if (this.hasmin) {
            this.setMin(ConfigEntryLong.readLong(bufferedReader, "min"));
        } else {
            this.setNoMin();
        }
        this.hasmax = ConfigEntryLong.readBoolean(bufferedReader, "hasmax");
        if (this.hasmax) {
            this.setMax(ConfigEntryLong.readLong(bufferedReader, "max"));
        } else {
            this.setNoMax();
        }
    }
}

